# This is a part of the Microsoft Foundation Classes C++ library.
# Copyright (C) 1992-1995 Microsoft Corporation
# All rights reserved.
#
# This source code is only intended as a supplement to the
# Microsoft Foundation Classes Reference and related
# electronic documentation provided with the library.
# See these sources for detailed information regarding the
# Microsoft Foundation Classes product.

# M[FRS]WN40[D].DLL is a DLL
#  which exports all the MFC/NET classes
#
# If you need a private build of the MFC NET DLL, be sure to rename
#  "MRWN40.DLL" to something more appropriate for you application.
# Please do not re-distribute a privately built version with the
#  name "MRWN40.DLL" or "MFCN40.DLL".
#
# Use nmake /f mfcnet.mak LIBNAME=<my name> to do this.
#
# Note: LIBNAME must be 6 characters or less.

!ifndef LIBNAME
!error LIBNAME is not defined. LIBNAME=MRWN40 builds the prebuilt INTEL DLL.
!endif

# Default PLATFORM depending on host environment
!ifndef PLATFORM
!ifndef PROCESSOR_ARCHITECTURE
PROCESSOR_ARCHITECTURE=x86
!endif
!if "$(PROCESSOR_ARCHITECTURE)" == "x86"
PLATFORM=INTEL
!endif
!if "$(PROCESSOR_ARCHITECTURE)" == "MIPS"
PLATFORM=MIPS
!endif
!if "$(PROCESSOR_ARCHITECTURE)" == "ALPHA"
PLATFORM=ALPHA
!endif
!if "$(PROCESSOR_ARCHITECTURE)" == "PPC"
PLATFORM=PPC
!endif
!endif

# Normalize case
!if "$(PLATFORM)" == "intel"
PLATFORM=INTEL
!endif
!if "$(PLATFORM)" == "alpha"
PLATFORM=ALPHA
!endif

!if "$(PLATFORM)" == "INTEL"
!ifndef CONVENTION
CONVENTION=R
!endif
!else
CONVENTION=W
!endif

!if "$(CONVENTION)" == "r"
CONVENTION=R
!endif
!if "$(CONVENTION)" == "s"
CONVENTION=S
!endif
!if "$(CONVENTION)" == "w"
CONVENTION=W
!endif
!if "$(PLATFORM)" == "INTEL"
!if "$(CONVENTION)" != "R" 
!if "$(CONVENTION)" != "S"
!error Must set either S (STACK) or R (REGISTER) calling convention
!endif
!endif
!endif

!if "$(DEBUG)" != "0"
#CRTDLL=msvcrtd.lib
!else
#CRTDLL=msvcrt.lib
!endif

TARGET=w
DLL=2
TARG=$(LIBNAME)
MFCDLL=MFC40
TARGDEFS=/D_AFX_NET_IMPL
#LFLAGS=/nodefaultlib

!if "$(PLATFORM)" == "INTEL"
MFCDLL=M$(CONVENTION)W40
!elseif "$(PLATFORM)" == "ALPHA"
MFCDLL=MFW40
!endif

!if "$(UNICODE)" == "1"
TARG=$(TARG)U
MFCDLL=$(MFCDLL)U
!endif

!if "$(DEBUG)" != "0"
# Debug DLL build
RCDEFINES=/D_DEBUG
LFLAGS=$(LFLAGS)
PCH_FILE=$D\stdafxn.pch
PCH_CPP=dllnet
TARG=$(TARG)D
MFCDLL=$(MFCDLL)D

!ELSE
# Release DLL build
RCDEFINES=
LFLAGS=$(LFLAGS)
PCH_FILE=$D\stdafxn.pch
PCH_CPP=dllnet
!ENDIF

DEFFILE=$(PLATFORM)\$(TARG).DEF

MFCDLL=..\lib\$(MFCDLL).lib

!if "$(DEBUGTYPE)" == ""
DEBUGTYPE=cv
!endif

!if "$(CODEVIEW)" != "0"
!if "$(REGEN)" != "1"
LFLAGS=$(LFLAGS) /debug:full /debugtype:$(DEBUGTYPE)
!else
LFLAGS=$(LFLAGS) /debug:none
!endif
!if "$(NO_PDB)" != "1" && "$(REGEN)" != "1"
LFLAGS=$(LFLAGS) /pdb:$(TARG).pdb
!else
LFLAGS=$(LFLAGS) /pdb:none
!endif
!else
LFLAGS=$(LFLAGS) /debug:none /incremental:no
!endif

!ifdef RELEASE # Release VERSION info
RCDEFINES=$(RCDEFINES) /DRELEASE
LFLAGS=$(LFLAGS) /release
!endif

LFLAGS=$(LFLAGS) /dll /version:4.1 /base:0x5FB00000

# OPT:noref keeps unreferenced functions (ie. no dead-code elimination)
!if "$(REGEN)" == "1"
LFLAGS=$(LFLAGS) /opt:noref
!else
LFLAGS=$(LFLAGS) /opt:noref
!endif

LIBS=$(MFCDLL) $(CRTDLL) kernel32.lib gdi32.lib user32.lib

!if "$(ORDER)" == "1"
!if exist($(PLATFORM)\$(TARG).prf)
DEFS=$(DEFS) /D_AFX_FUNCTION_ORDER
LFLAGS=$(LFLAGS) /order:@$(PLATFORM)\$(TARG).prf
!endif
!endif

dll_goal: create2.dir $(TARG).dll ..\lib\$(TARG).lib

#############################################################################
# import most rules and library files from normal makefile

#
# Set any DLL-specific Watcom C/C++ options here.
#
EXTRA_WOPTS=-bd

!include makefile

create2.dir:
	@-if not exist $D\*.* mkdir $D

#############################################################################
# Build target

$D\$(TARG).res: mfcnet.rc build_.h
	rc /r $(RCDEFINES) /fo $D\$(TARG).res mfcnet.rc

DLL_OBJS=$(SOCKETS)

$(TARG).dll ..\lib\$(TARG).lib: $D\$(PCH_CPP).obj $(DLL_OBJS) $(DEFFILE) $D\$(TARG).res
	$(LINKER) @<<
/passwopts:"disable 121"
/nofuzzy
$(LFLAGS)
$(LIBS)
$D\$(PCH_CPP).obj
$(DLL_OBJS)
$D\$(TARG).res
/def:$(DEFFILE)
/out:$(TARG).DLL
/map:$D\$(TARG).MAP
/implib:..\lib\$(TARG).LIB
<<
	if exist ..\lib\$(TARG).exp del ..\lib\$(TARG).exp

#############################################################################
